
export async function onRequest({ request, params, env }) {
    if (request.method === 'OPTIONS') {
        return new Response(null, {
            headers: {
                'Access-Control-Allow-Origin': '*',
                'Access-Control-Allow-Methods': 'GET, OPTIONS',
                'Access-Control-Allow-Headers': 'Content-Type',
                'Access-Control-Max-Age': '86400',
            },
        });
    }

    let uri = '';
    if (!params || !('cnburi' in params)) {
        uri = 'index.html';
    } else {
        const paths = params.cnburi;
        if (typeof paths === 'string') {
            uri = paths;
        } else if (Array.isArray(paths)) {
            uri = paths.map(encodeURIComponent).join('/');
        }

    }

    if (!uri || uri === '' || uri === '/') {
        uri = 'index.html';
    }

    if (uri.endsWith('/')) {
        uri = `${uri}index.html`
    }

    const tryFetch = async (path) => {
        // 仓库/分支地址
        const url = `https://cnb.cool/onedayxyy/hugo-teek/-/git/raw/dist/${path}`;
        const response = await fetch(url, {
            headers: {
                'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36',
                'Referer': url,
            },
        });
        return { response, url };
    };
    let { response } = await tryFetch(uri);

    if (!response.ok || !response.body) {
        if (!isFileURI(uri)) {
            if (uri.endsWith('/')) {
                uri = `${uri}index.html`
            } else {
                uri = `${uri}/index.html`
            }
        } else {
            uri = 'index.html';
        }

        ({ response } = await tryFetch(uri));
    }

    if (!response.ok || !response.body) {
        // 404设置,从相同的仓库获取404.html
        try {
            const html404Url = `https://cnb.cool/onedayxyy/hugo-teek/-/git/raw/dist/404.html`;
            const html404Response = await fetch(html404Url, {
                headers: {
                    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36',
                    'Referer': html404Url,
                },
            });
            
            if (html404Response.ok && html404Response.body) {
                return new Response(html404Response.body, {
                    status: 404,
                    headers: {
                        "Content-Type": "text/html; charset=utf-8",
                        'Access-Control-Allow-Origin': '*',
                    },
                });
            }
        } catch (error) {
        }
        
        return new Response('Not Found', {
            status: 404,
            headers: {
                'Access-Control-Allow-Origin': '*',
            },
        });
    }
    return new Response(response.body, {
        headers: {
            'Content-Type': getContentTypeFromURI(uri) || response.headers.get('content-type') || 'application/octet-stream',
            'Access-Control-Allow-Origin': '*',
            'Cache-Control': 'public, max-age=3600',
        },
    });
}

function isFileURI(uri) {
    const pathname = new URL(uri, 'http://dummy').pathname;
    return /\.[^\/]+$/.test(pathname);
}

function getContentTypeFromURI(uri) {
    const mimeMap = {
        'html': 'text/html',
        'htm': 'text/html',
        'css': 'text/css',
        'js': 'application/javascript',
        'mjs': 'application/javascript',
        'json': 'application/json',
        'xml': 'application/xml',
        'txt': 'text/plain',
        'csv': 'text/csv',
        'jpg': 'image/jpeg',
        'jpeg': 'image/jpeg',
        'png': 'image/png',
        'gif': 'image/gif',
        'webp': 'image/webp',
        'svg': 'image/svg+xml',
        'ico': 'image/x-icon',
        'bmp': 'image/bmp',
        'tiff': 'image/tiff',
        'avif': 'image/avif',
        'mp3': 'audio/mpeg',
        'wav': 'audio/wav',
        'ogg': 'audio/ogg',
        'mp4': 'video/mp4',
        'webm': 'video/webm',
        'ogv': 'video/ogg',
        'pdf': 'application/pdf',
        'zip': 'application/zip',
        'tar': 'application/x-tar',
        'gz': 'application/gzip',
        'rar': 'application/vnd.rar',
        '7z': 'application/x-7z-compressed',
        'doc': 'application/msword',
        'docx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        'xls': 'application/vnd.ms-excel',
        'xlsx': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'ppt': 'application/vnd.ms-powerpoint',
        'pptx': 'application/vnd.openxmlformats-officedocument.presentationml.presentation'
    };

    try {
        const ext = uri.split('.').pop().toLowerCase();
        return mimeMap[ext] || 'application/octet-stream';
    } catch (e) {
        // 无效 URI
    }
    return 'application/octet-stream';
}